;/*************************************************
; Program		:RS232 interface.
; CPU Control	:ATmega163
; File name		:RS232.asm
; Assembler		:AVR Studio 4.05
;**************************************************

.include "m163def.inc"			

.org   	$000 
    		rjmp  reset				;Reset Handle
;/************************
; Define Register
;/************************
.def		counter1  	= r16
.def		counter2	= r17
.def		temp		= r19
.def		data		= r21
;/*******************
; Main Program
;/*******************
reset:      ldi	temp,low(RAMEND)
            out	SPL,temp          	;init Stack Pointer     
            ldi	temp,high(RAMEND)
            out	SPH,temp        	
main:		sbi	UCR,TXEN			;enable transmit
			sbi	UCR,RXEN			;enable receive 
			ldi	temp,51				;baud rate = 9600bps
			out	UBRR,temp

RS232:		ldi	ZH,high(2*RS232TB)
			ldi	ZL,low(2*RS232TB)
			rcall	Intro
Sub_RS232:	rcall	RX_Byte
			rcall	TX_Byte
			rjmp	Sub_RS232

;/********************
; Send text
;/********************
Intro:		lpm
			tst	r0
			breq	end_sub
TX232:		sbis	USR,UDRE
			rjmp	TX232
			out	UDR,r0
			adiw	ZL,1
			rjmp	Intro
end_sub:	ret		

;/******************
; Send a byte
;/******************

TX_Byte:	sbis	USR,UDRE
			rjmp	TX_Byte
			out	UDR,data
			ret

;/*****************
; Get a byte
;/*****************
RX_Byte:	sbis	USR,RXC
			rjmp	RX_Byte
			in	data,UDR
			ret

;/***************
; text segment
;/***************
RS232TB:	.db	"Test RS232 interface. ",0x0a,0x0d
			.db	"Please enter any key to echo.",0x0a,0x0d,0
           	 